package rappels ;

	use strict;
	use warnings "all";
	use Locale::gettext;

	use vars qw($gladexml) ;
	# $gladexml est donc la variable qui fera rfrence  l'arbre xml
	# de l'application.
	# On initialise la valeur de la variable quand l'arbre est cr
	# dans le module principale

	sub init {
		# Dmarage de l'interface graphique
		$gladexml = $X::gladexml ;
		bindtextdomain("helloworld", "./locale");
		textdomain("helloworld");
		# Sans traduction
		print "HelloWorld\n";
		# Avec traduction
		print gettext("HelloWorld"), "\n";
	}
	sub on_window1_delete_event{
		Gtk2->main_quit ;
	}
	sub on_bouton_quitter_clicked{
		Gtk2->main_quit ;
	}

1 ; 

package X ;

	use strict ;
	use Locale::gettext;

	bindtextdomain("helloworld", "./locale");
	textdomain("helloworld");

	require Exporter ;
	use vars qw(@EXPORT_OK) ;
	@EXPORT_OK = qw ($gladexml) ;
	use vars qw($gladexml) ;

	use Gtk2 '-init' ;
	use Gtk2::GladeXML ;

	# On cre l'arbre xml complet. Attention, toutes les fentres dclares
	# visibles dans le menu Proprits->commun->visible, seront affiches
	# quand on lancera "Gtk2->main".
	$gladexml = Gtk2::GladeXML->new('helloworld.glade' ) ;
	# On initialise les variables du module rappels.
	rappels::init () ;
	# On connecte les fonctions de rappels de l'arbre xml
	#  leurs dfinitions qui sont contenues dans le module rappels.
	$gladexml->signal_autoconnect_from_package('rappels' ) ;

1 ;
